#include <QMessageBox>
#include "hopfengabe.h"
#include "ui_hopfengabe.h"
#include <QDebug>
#include "definitionen.h"

hopfengabe::hopfengabe(QWidget *parent) :
	QWidget(parent),
	ui(new Ui::hopfengabe)
{
	ui->setupUi(this);
	prozentOK = false;
	ui->dsb_Menge->setValue(10);
	ui->dsb_MengeGramm->setMinimum(0);
	NativStyle = NATIV_STYLE;

	//Betriebssystemeigenen Style benutzen
	if (NativStyle) {
		//Einstellungen abhängig vom Betriebssystem
		//Linux
		#ifdef Q_WS_X11
		#endif

		//Mac OS
		#ifdef Q_WS_MAC
		#endif

		//Windows
		#ifdef Q_WS_WIN
			ui->frame->setFrameShape(QFrame::Panel);
			ui->pushButton_del->setMinimumWidth(22);
			ui->pushButton_del->setMaximumWidth(22);
			ui->pushButton_del->setMaximumHeight(18);
		#endif

	}
	else {
		ui->pushButton_del->setMinimumWidth(22);
		ui->pushButton_del->setMaximumWidth(22);
		ui->pushButton_del->setMaximumHeight(18);

	}
}

hopfengabe::~hopfengabe()
{
	delete ui;
}

void hopfengabe::setID(int value)
{
	ID = value;
}

int hopfengabe::getID()
{
	return ID;
}

void hopfengabe::setHopfenListe(QStringList value)
{
	hopfenListe = value;
	ErstelleAuswahlliste();
}
bool hopfengabe::getBierWurdeGebraut() const
{
	return BierWurdeGebraut;
}

void hopfengabe::setBierWurdeGebraut(bool value)
{
	BierWurdeGebraut = value;
	if (value)
		setFehlProzent(0);
}

void hopfengabe::setVWH(bool value)
{
	ui->checkBox_vwh->setChecked(value);
}

int hopfengabe::getMaxKochzeit() const
{
	return MaxKochzeit;
}

void hopfengabe::setMaxKochzeit(int value)
{
	MaxKochzeit = value;
	ui->spinBox_Kochdauer->setMaximum(value);
	if (ui->checkBox_vwh->isChecked()){
		ui->spinBox_Kochdauer->setValue(MaxKochzeit);
	}
}

void hopfengabe::setFehlProzent(double value)
{
	ui->pushButton_KorrekturMenge->setText(QString::number(value));
	if (value == 0){
		ui->pushButton_KorrekturMenge->setVisible(false);
		ergWidget->setVisible(true);
	}
	else{
		ui->pushButton_KorrekturMenge->setVisible(true);
		ergWidget->setVisible(false);
	}
}

double hopfengabe::getMengeProzent()
{
	return ui->dsb_Menge->value();
}

void hopfengabe::setMengeProzent(double value)
{
	ui->dsb_Menge->setValue(value);
}

void hopfengabe::setName(QString Name)
{
	if (!BierWurdeGebraut){
		bool gefunden = false;
		for (int i=0; i < ui->comboBox_Zutat -> count(); i++){
			if (ui->comboBox_Zutat -> itemText(i) == Name){
				ui->comboBox_Zutat -> setCurrentIndex(i);
				ergWidget -> label_Beschreibung -> setText(Name);
				gefunden = true;
			}
		}
		if (!gefunden){
			QMessageBox::information ( this,"", trUtf8("Rohstoffeintrag in den Hopfenzutaten ist nicht mehr vorhanden")
																 + " (" + Name +") " + trUtf8("Es wird der erste Mögliche Eintrag ausgewählt")) ;
		}
	}
	else {
		ui->comboBox_Zutat -> clear();
		ui->comboBox_Zutat -> addItem(Name);
		ui->comboBox_Zutat -> setCurrentIndex(0);
	}
}

QString hopfengabe::getName()
{
	 return ui->comboBox_Zutat->currentText();
}

void hopfengabe::setErgMenge(double value)
{
	ui->dsb_MengeGramm->setValue(value);
	MengeGrammWertAlt = ui->dsb_MengeGramm->value();
	ergWidget->spinBox_Wert->setValue(value);

	QString s;
	s = ui->comboBox_Zutat->currentText();
	if (Pellets)
		s += trUtf8("  (Pellets) ");
	else
		s += trUtf8("  (Dolden) ");
	s += QString::number(Alpha)+" % Alpha";
	ergWidget->label_Beschreibung->setText(s);

	if (ui->checkBox_vwh->isChecked()){
		ui->spinBox_Kochdauer->setEnabled(false);
		ui->spinBox_Kochdauer->setValue(MaxKochzeit);
	}
	else {
		ui->spinBox_Kochdauer->setEnabled(true);
	}
	//Menge für 100Prozent berechnen
	Menge100Prozent = value / ui->spinBox_IBUAnteil->value() * SollIBU;
	ui->dsb_MengeGramm->setMaximum(Menge100Prozent);
}

double hopfengabe::getErgMenge()
{
	return ergWidget->spinBox_Wert->value();
}

void hopfengabe::setKochzeit(int value)
{
	ui->spinBox_Kochdauer->setValue(value);
}

int hopfengabe::getKochzeit()
{
	return ui->spinBox_Kochdauer->value();
}

void hopfengabe::setDisabled(bool status)
{
	QAbstractSpinBox::ButtonSymbols bs;

	if (!status) {
		bs = QAbstractSpinBox::UpDownArrows;
	}
	else {
		bs = QAbstractSpinBox::NoButtons;
	}

	ui->comboBox_Zutat -> setDisabled(status);
	ui->comboBox_Zutat->setEditable(status);
	ui->dsb_MengeGramm -> setDisabled(status);
	ui->dsb_MengeGramm -> setButtonSymbols(bs);
	ui->dsb_Menge -> setDisabled(status);
	ui->dsb_Menge -> setButtonSymbols(bs);
	ui->checkBox_vwh -> setDisabled(status);
	ui->pushButton_KorrekturMenge->setVisible(!status);
	ui->pushButton_del -> setDisabled(status);
	ui->spinBox_Kochdauer -> setDisabled(status);
	ui->spinBox_Kochdauer -> setButtonSymbols(bs);
	ui->spinBox_IBUAnteil->setVisible(!status);
	ui->label_IBUAnteil->setVisible(!status);
	ui->label_IBUAnteil_2->setVisible(!status);
	ui->spinBox_Ausbeute->setVisible(!status);
	ui->label_Ausbeute->setVisible(!status);
	ui->label_Ausbeute_2->setVisible(!status);
	ui->label_Mengeneinheit_2->setVisible(!status);
	ui->dsb_MengeGramm->setVisible(!status);
}

bool hopfengabe::getVWH()
{
	return ui->checkBox_vwh->checkState();
}

void hopfengabe::setIBUAnteil(double value)
{
	ui->spinBox_IBUAnteil->setValue(value);
}

void hopfengabe::setBerIBUProzent(bool value)
{
	QAbstractSpinBox::ButtonSymbols bs;

	berIBUProzent = value;
	if (value){
		bs = QAbstractSpinBox::UpDownArrows;
		ui->dsb_MengeGramm->setDisabled(false);
		ui->dsb_MengeGramm->setButtonSymbols(bs);
	}
	else {
		bs = QAbstractSpinBox::NoButtons;
		ui->dsb_MengeGramm->setDisabled(true);
		ui->dsb_MengeGramm->setButtonSymbols(bs);
	}
	
}

QString hopfengabe::getErgebnistext()
{
	return ergWidget->label_Beschreibung->text();
}


bool hopfengabe::getPellets() const
{
	return Pellets;
}

void hopfengabe::setPellets(bool value)
{
	Pellets = value;
}


void hopfengabe::on_pushButton_del_clicked()
{
	if (faderWidget)
		faderWidget->close();

	faderWidget = new FaderWidget(this);
	connect(faderWidget, SIGNAL(sig_fertig()), this, SLOT(on_fadeout_fertig()));
	animationAktiv = true;
	faderWidget->start();
}

void hopfengabe::on_fadeout_fertig()
{
	emit sig_vorClose(ID);
	close();
}

void hopfengabe::ErstelleAuswahlliste()
{
	if (!BierWurdeGebraut){
		//Aktuelle Auswahl speichern
		QString s = ui->comboBox_Zutat -> currentText();
		ui->comboBox_Zutat -> clear();
		ui->comboBox_Zutat -> addItems(hopfenListe);

		//zwischengespeicherte auswahl wieder anwählen
		for (int i=0; i < ui->comboBox_Zutat -> count(); i++){
			if (ui->comboBox_Zutat -> itemText(i) == s){
				ui->comboBox_Zutat -> setCurrentIndex(i);
			}
		}
	}
}

void hopfengabe::closeEvent(QCloseEvent *)
{
	emit sig_Aenderung();
	ergWidget -> close();
}

void hopfengabe::on_dsb_Menge_valueChanged(double )
{
	emit sig_Aenderung();
}

double hopfengabe::getAlpha() const
{
	return Alpha;
}

void hopfengabe::setAlpha(double value)
{
	Alpha = value;
}

void hopfengabe::setSollIBU(double value)
{
	SollIBU = value;
}

void hopfengabe::setAusbeute(double value)
{
	ui->spinBox_Ausbeute->setValue(value);
}

void hopfengabe::on_pushButton_KorrekturMenge_clicked()
{
	ui->dsb_Menge->setValue(ui->dsb_Menge->value()+ui->pushButton_KorrekturMenge->text().toDouble());
}

void hopfengabe::on_comboBox_Zutat_currentIndexChanged(const QString &)
{
	emit sig_Aenderung();
}

void hopfengabe::on_checkBox_vwh_clicked()
{
	emit sig_Aenderung();
}

void hopfengabe::on_spinBox_Kochdauer_valueChanged(int )
{
	emit sig_Aenderung();
}

void hopfengabe::on_dsb_MengeGramm_valueChanged(double )
{
}

void hopfengabe::on_dsb_MengeGramm_editingFinished()
{
	if (ui->dsb_MengeGramm->value() != MengeGrammWertAlt){
		MengeGrammWertAlt = ui->dsb_MengeGramm->value();
		qDebug() << "dsb_MengeGramm" << ui->dsb_MengeGramm->value();
		if (berIBUProzent)
			ui->dsb_Menge->setValue(ui->dsb_MengeGramm->value()/Menge100Prozent*100);
	}
}
